# run_skeleton_task.py (Completed Executable Code)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Object Names from the Problem Definition ===
        # Drawers
        drawer1 = "drawer1"
        drawer2 = "drawer2"
        drawer3 = "drawer3"
        # Handles
        drawer_top_handle = "drawer_top_handle"
        drawer_middle_handle = "drawer_middle_handle"
        drawer_bottom_handle = "drawer_bottom_handle"
        # Dice
        dice1 = "dice1"
        dice2 = "dice2"
        # Locations
        ready_pose = "ready-pose"
        floor = "floor"
        drawer_area = "drawer-area"

        # === Exploration Phase: Identify Missing Predicate ===
        # The feedback and exploration domain suggest that we need to check for missing predicates,
        # such as lock-known, identified, etc. For this, we simulate an exploration step.
        # For this example, let's assume we want to check if the lock status of drawer3 is known.
        # If not, we perform an exploration action (e.g., try to pull the handle and observe the result).

        # We'll use the available skills and the object list to ensure correct names.

        # 1. Move robot to ready-pose if not already there
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=positions.get("robot", ready_pose),
                to_location=ready_pose
            )
        except Exception as e:
            print(f"[Exploration] Error moving to ready-pose: {e}")

        # 2. Move to drawer3 area (drawer-area)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=ready_pose,
                to_location=drawer_area
            )
        except Exception as e:
            print(f"[Exploration] Error moving to drawer-area: {e}")

        # 3. Pick up the handle for drawer3 (drawer_bottom_handle)
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=drawer_bottom_handle,
                location=drawer_area
            )
        except Exception as e:
            print(f"[Exploration] Error picking up handle {drawer_bottom_handle}: {e}")

        # 4. Try to pull the handle to open drawer3 (explore lock-known predicate)
        try:
            obs, reward, done = execute_pull(
                env,
                task,
                drawer=drawer3,
                handle=drawer_bottom_handle,
                location=drawer_area
            )
            print("[Exploration] Pulled handle to check lock status of drawer3.")
        except Exception as e:
            print(f"[Exploration] Error pulling handle {drawer_bottom_handle} for {drawer3}: {e}")

        # === Main Task Plan: Put dice1 and dice2 into drawer1 ===

        # 5. Move to dice1 location (assume on floor at ready-pose)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=drawer_area,
                to_location=ready_pose
            )
        except Exception as e:
            print(f"[Task] Error moving to ready-pose for dice1: {e}")

        # 6. Pick up dice1
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=dice1,
                location=ready_pose
            )
        except Exception as e:
            print(f"[Task] Error picking up {dice1}: {e}")

        # 7. Move to drawer1 (assume drawer1 is at drawer-area)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=ready_pose,
                to_location=drawer_area
            )
        except Exception as e:
            print(f"[Task] Error moving to drawer-area for placing {dice1}: {e}")

        # 8. Place dice1 into drawer1
        try:
            obs, reward, done = execute_place(
                env,
                task,
                object_name=dice1,
                drawer=drawer1,
                location=drawer_area
            )
        except Exception as e:
            print(f"[Task] Error placing {dice1} into {drawer1}: {e}")

        # 9. Move to dice2 location (assume on floor at ready-pose)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=drawer_area,
                to_location=ready_pose
            )
        except Exception as e:
            print(f"[Task] Error moving to ready-pose for dice2: {e}")

        # 10. Pick up dice2
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=dice2,
                location=ready_pose
            )
        except Exception as e:
            print(f"[Task] Error picking up {dice2}: {e}")

        # 11. Move to drawer1 (drawer-area)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=ready_pose,
                to_location=drawer_area
            )
        except Exception as e:
            print(f"[Task] Error moving to drawer-area for placing {dice2}: {e}")

        # 12. Place dice2 into drawer1
        try:
            obs, reward, done = execute_place(
                env,
                task,
                object_name=dice2,
                drawer=drawer1,
                location=drawer_area
            )
        except Exception as e:
            print(f"[Task] Error placing {dice2} into {drawer1}: {e}")

        # 13. Optionally, close drawer1 if required (not specified in goal, but possible)
        # try:
        #     obs, reward, done = execute_push(
        #         env,
        #         task,
        #         drawer=drawer1,
        #         location=drawer_area
        #     )
        # except Exception as e:
        #     print(f"[Task] Error closing {drawer1}: {e}")

        print("[Task] Finished putting dice1 and dice2 into drawer1.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()