"""Module to store two dice in the open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task_store_two_dice():
    """Stores two dice in the open drawer."""
    robot = RobotController()
    try:
        # Step 1: Pick up the first die at ready-pose
        robot.execute_movement(Object["die1"], mode=1, axis=0)
        # Step 2: Place the first die into drawer1 at ready-pose (drawer1 is open)
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)
        # Step 3: Pick up the second die at ready-pose
        robot.execute_movement(Object["die2"], mode=1, axis=0)
        # Step 4: Place the second die into drawer1 at ready-pose
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the dice storing task."""
    long_horizon_task_store_two_dice()

if __name__ == "__main__":
    main()