from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Sequence for: Put two dice in the already open drawer.
    Assumes dice1 and dice2 are on the floor at ready-pose, and drawer1 is already open.
    """
    robot = RobotController()

    # Pick up dice1 from the floor at ready-pose
    robot.execute_pick(Object["dice1"], Object["ready-pose"])
    # Place dice1 into the already open drawer1 at ready-pose
    robot.execute_place(Object["dice1"], Object["drawer1"], Object["ready-pose"])

    # Pick up dice2 from the floor at ready-pose
    robot.execute_pick(Object["dice2"], Object["ready-pose"])
    # Place dice2 into the already open drawer1 at ready-pose
    robot.execute_place(Object["dice2"], Object["drawer1"], Object["ready-pose"])

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()