"""Module to insert a pair of dice into the open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick up two dice and insert them into the open drawer."""
    robot = RobotController()

    try:
        # Step 1: Pick up the first die at ready-pose
        robot.execute_movement(Object["die1"], mode=1, axis=0)

        # Step 2: Place the first die into the open drawer (drawer1) at ready-pose
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)

        # Step 3: Pick up the second die at ready-pose
        robot.execute_movement(Object["die2"], mode=1, axis=0)

        # Step 4: Place the second die into the open drawer (drawer1) at ready-pose
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the dice insertion task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()