"""Module to store two dice in the open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Stores two dice in the open drawer."""
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from the floor at ready-pose
        robot.execute_movement(Object["dice1"], mode=1, axis=0)

        # Step 2: Place dice1 into the open drawer1 at ready-pose
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)

        # Step 3: Pick up dice2 from the floor at ready-pose
        robot.execute_movement(Object["dice2"], mode=1, axis=0)

        # Step 4: Place dice2 into the open drawer1 at ready-pose
        robot.execute_movement(Object["drawer1"], mode=2, axis=0)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()