from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Move two dice to the drawer that's already open (drawer1).
    Assumes dice1 and dice2 are present in Object_list and accessible.
    """
    robot = RobotController()
    try:
        # Move to the location of dice1
        robot.execute_movement(Object["dice1"], mode=1)
        # Place dice1 into the open drawer (drawer1)
        robot.execute_movement(Object["drawer1"], mode=2)

        # Move to the location of dice2
        robot.execute_movement(Object["dice2"], mode=1)
        # Place dice2 into the open drawer (drawer1)
        robot.execute_movement(Object["drawer1"], mode=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """
    Main function to execute the long horizon task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()