"""Module to move two dice (dice1 and dice2) to the already open drawer (drawer1)."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Moves dice1 and dice2 from the floor to the already open drawer1."""
    robot = RobotController()

    # Move to ready pose if not already there
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=8)
    except Exception as exc:
        pass

    # Pick dice1 at ready-pose
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as exc:
        print(f"Error in execute_pick for dice1: {exc}")

    # Place dice1 in drawer1 (already open) at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as exc:
        print(f"Error in execute_place for dice1: {exc}")

    # Pick dice2 at ready-pose
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as exc:
        print(f"Error in execute_pick for dice2: {exc}")

    # Place dice2 in drawer1 (already open) at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as exc:
        print(f"Error in execute_place for dice2: {exc}")

def main():
    """Main entry point to execute the dice moving task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()