"""Module to place two dice into the open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Place two dice into the open drawer."""
    robot = RobotController()

    # Identify all dice objects
    dice_objects = [obj_name for obj_name in Object if "dice" in obj_name]

    # Find the open drawer
    open_drawer = None
    for drawer_name in Object:
        if "drawer" in drawer_name and Object[drawer_name].is_open:
            open_drawer = drawer_name
            break

    if open_drawer is None or len(dice_objects) < 2:
        print("Error: Could not find an open drawer or two dice.")
        return

    # Place two dice into the open drawer
    for dice_name in dice_objects[:2]:
        try:
            robot.execute_movement(Object[dice_name], mode=1, axis=2)  # Pick
            robot.execute_movement(Object[dice_name], mode=2, axis=2, target_drawer=Object[open_drawer])  # Place
        except Exception as error:
            print(f"Error during pick and place for {dice_name}: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()