from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 at its pose/location (from floor), axis=2 (approach from above)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 2: Place dice1 into the open drawer (assume left spot in drawer), axis=2
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

        # Step 3: Pick up dice2 at its pose/location (from floor), axis=2 (approach from above)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)  # execute_pick

        # Step 4: Place dice2 into the open drawer (assume right spot in drawer), axis=2
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)  # execute_place

    except Exception as e:
        print(f"Error during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()