from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # =========================================
    # Oracle sequence for: Insert a pair of dice into the open drawer.
    # Steps strictly according to the provided specification and mapping.
    # Only use execute_pick & execute_place with correct axes.
    # =========================================

    try:
        # Step 1: Pick up dice1 from its location (top-down: axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error at step 1 (execute_pick dice1): {e}")

    try:
        # Step 2: Place dice1 into the open drawer (left position, axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error at step 2 (execute_place dice1): {e}")

    try:
        # Step 3: Pick up dice2 from its location (top-down: axis=2)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error at step 3 (execute_pick dice2): {e}")

    try:
        # Step 4: Place dice2 into the open drawer (right position, axis=2)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error at step 4 (execute_place dice2): {e}")

    try:
        # Move to ready pose for safety/handover
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error moving to ready pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()