from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for: Store two dice in the open drawer.

    Required skills: execute_pick, execute_place
    Plan steps (from specification):
      1. execute_pick dice1 at its location
      2. execute_place dice1 in drawer at the correct location
      3. execute_pick dice2 at its location
      4. execute_place dice2 in drawer at the correct location

    Assumptions from environment:
    - 'dice1' and 'dice2' are on the floor, ready to pick.
    - Drawer is already open and can receive dice.
    - Placing: Use "drawer_top_place_left" for dice1, "drawer_top_place_right" for dice2.
    - For picking dice: axis=2 (z-axis approach).
    - For placing in drawer: axis=2 (z-axis approach).
    - Always return to ready pose (mode=8) after pick or place.
    """

    robot = RobotController()

    try:
        # Step 1: Pick up dice1
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)

        # Step 2: Place dice1 into the open drawer (left slot)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)

        # Step 3: Pick up dice2
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        robot.execute_movement(mode=8)

        # Step 4: Place dice2 into the open drawer (right slot)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        robot.execute_movement(mode=8)

    except KeyError as e:
        print(f"Object key error: {e}. Please check Object list for missing entry.")
    except Exception as e:
        print(f"Execution error: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
