from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Store two dice in the open drawer.
    Plan:
        1. execute_pick (dice1, dice1_location)
        2. execute_place (dice1, drawer, drawer_location)
        3. execute_pick (dice2, dice2_location)
        4. execute_place (dice2, drawer, drawer_location)
    Execution Note:
        - "dice1_location": placement pose for dice1 (Object["dice1"])
        - "drawer_top_place_left": place pose in open drawer for dice1
        - "dice2_location": placement pose for dice2 (Object["dice2"])
        - "drawer_top_place_right": place pose in open drawer for dice2
        - Approach general objects from z-axis (axis=2)
    """
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick for dice1: {e}")

    try:
        # Step 2: Place dice1 in open drawer (left position, z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place for dice1: {e}")

    try:
        # Step 3: Pick up dice2 (approach along z-axis)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick for dice2: {e}")

    try:
        # Step 4: Place dice2 in open drawer (right position, z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place for dice2: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()