from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to move both dice to the open drawer using only allowed skills.
    Follows the step-by-step specification strictly.
    """
    robot = RobotController()

    try:
        # Step 1: Go from current location to dice1's location
        robot.execute_movement(Object["dice1"], mode=7)
        
        # Step 2: Pick dice1 (z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 3: Go from dice1_location to open drawer location
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # Step 4: Place dice1 into the open drawer (z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 5: Go to dice2's location
        robot.execute_movement(Object["dice2"], mode=7)

        # Step 6: Pick dice2 (z-axis)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)

        # Step 7: Go to open drawer (for second place)
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)

        # Step 8: Place dice2 into the open drawer (z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
