# run_skeleton_task.py (Filled in for Exploration of Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # (do not redefine primitives, use only provided skill actions)

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation, including an exploration phase for missing predicates.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Find Missing Predicate about Drawer ===
        # Target predicate (from feedback): (drawer-unlocked drawer1)
        # Goal: Use only available skills to 'explore' the state of 'drawer1' (e.g., is it locked/unlocked?)
        # Since the exploration knowledge shows that 'execute_pull' can be used to "discover" lock status,
        # and among available skills we have 'execute_pull', we will call it accordingly.

        # The following logic assumes at least 1 drawer, one associated handle, and the robot can move/grasp.
        # These names will be found in the positions dictionary.
        # You may need to adjust these keys depending on your RLBench environment.

        # Example object/discovery logic (customize to your env's keys and structure)
        try:
            # Find the drawer and its handle (assuming naming convention: 'drawer1', 'handle1')
            drawer_name = None
            handle_name = None
            location_name = None

            # Try to infer correct keys
            # Find the first drawer and handle (fallback if not in dict)
            for k in positions:
                if 'drawer' in k:
                    drawer_name = k
                if 'handle' in k:
                    handle_name = k
                if 'location' in k:
                    location_name = k

            if drawer_name is None or handle_name is None:
                raise ValueError("Could not find drawer or handle object in positions dict. Check naming.")

            # Get positions for manipulation
            drawer_pos = positions[drawer_name]
            handle_pos = positions[handle_name]

            # If locations are specified, pick a start/end location (otherwise, use a default)
            if location_name is not None:
                robot_location = positions[location_name]
            else:
                robot_location = (0, 0, 0)  # Default/fallback: origin if not specified

            print(f"[Exploration] Attempting to pull handle '{handle_name}' on drawer '{drawer_name}' to check lock...")

            # 1. Move robot to handle location (using execute_go)
            obs, reward, done = execute_go(
                env, 
                task,
                from_location=robot_location, 
                to_location=handle_pos,
            )

            if done:
                print("[Exploration] Early termination after move; cannot continue exploration.")
                return

            # 2. Pick the handle (using execute_pick)
            obs, reward, done = execute_pick(
                env,
                task,
                obj=handle_name,
                location=handle_pos,
            )

            if done:
                print("[Exploration] Early termination after pick; cannot continue exploration.")
                return

            # 3. Try to pull the handle (using execute_pull) – this checks if drawer is locked/unlocked
            obs, reward, done = execute_pull(
                env,
                task,
                drawer=drawer_name,
                handle=handle_name,
                location=handle_pos,
            )

            if done:
                print("[Exploration] Early termination after pull; cannot continue exploration.")
                return

            print("[Exploration] Pull action executed; system should have discovered lock/unlock predicate.")

        except Exception as ex:
            print(f"[Exploration ERROR] {ex}")

        # TODO: Insert additional plan logic to achieve the task after exploration/discovery.
        # Example:
        #  - If drawer is unlocked, open and place objects.
        #  - If locked, try other actions or finish.

        # << Insert plan logic here as needed >>

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
