from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # === Step 1: Pick a drawer handle (to open a drawer) ===
        # We'll open the top drawer (drawer1), corresponding handle = handle1
        # In Object_list mapping: "drawer_top_handle" maps to pose of handle1 on the floor
        # axis=0: approach along x-axis is recommended for handle grasping

        # Pick up the handle (assumed to be on floor)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # === Step 2: Pull the drawer using picked handle ===
        # We'll execute the pull action (drawer1, handle1, at floor)
        # mode=4 for "execute_pull"
        # pose is again handle pose (as pulling at handle), distance=0.1 as typical pull
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)

        # (Goal is to open one drawer - this achieves it.)

    except Exception as e:
        print(f"An error occurred during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
