from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Plan:
    Step 1. Pick the handle of the drawer you want to open.
    Step 2. Pull (open) the drawer by using the handle.

    This follows the skeleton and specification exactly,
    using only the required skills: execute_pick & execute_pull.
    Handles possible exceptions gracefully.
    """
    robot = RobotController()

    # Select which drawer/handle to open. Let's open the top drawer (drawer1, handle1).
    handle_object = "drawer_top_handle"    # mapped to handle1 (from object mapping)
    handle_location = "floor"              # from observation: all handles are on floor at start
    drawer = "drawer1"                     # drawer to open

    # Map skeleton Object names and parameters (for generality and future extensibility).
    # You could swap to drawer_middle_handle/drawer2 etc if you wish to open a different drawer.

    # Step 1: Pick up the handle
    try:
        # Object[handle_object] gives the pose; axis=0 for handle (x-approach)
        robot.execute_movement(Object[handle_object], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on {handle_object}: {e}")
        return

    # Step 2: Pull (open) the drawer using the handle.
    try:
        # execute_pull on the drawer, using the handle, with x-approach
        # We pass the same pose (handle) for coordinated movement.
        robot.execute_movement(Object[handle_object], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error during execute_pull on {drawer} with {handle_object}: {e}")
        return


def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
