from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick(handle3, floor) -- pick the handle attached to a drawer (let's choose the top drawer)
    # In object_names, "drawer_top_handle" represents handle1 (as per the mapping)
    # We'll assume handle1 <-> "drawer_top_handle" <-> drawer1
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick for drawer_top_handle: {e}")
        return

    # Step 2: execute_pull(drawer1, handle1, floor) -- pull drawer1 open using the handle
    # Passing the handle object as the target, as pose (axis=0 for x direction, distance=0.1 per spec)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull for drawer_top_handle: {e}")
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()