from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan to: Pull open a single drawer.
    According to specification, use execute_pick to grasp the handle and execute_pull to open the drawer.
    By observation and object mapping, we choose handle1 (on-floor handle1 at ready-pose) for drawer1.
    Mapping:
      <drawer_handle>   -> 'drawer_top_handle'   (handle1)
      <drawer>          -> drawer1 (corresponds to handle1)
      <handle_location> -> 'drawer_top_handle'   (use the same since Object provides the handle's pose)
      <pull_location>   -> 'drawer_top_handle'   (pull from the same pose)
    Approach axis for handle: 0 (x-axis)
    """
    robot = RobotController()

    try:
        # Step 1: Pick up drawer handle (handle1, which maps to 'drawer_top_handle')
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: Pull open the drawer (drawer1) via its handle
        # We'll use mode=4 (execute_pull) at the same handle location, with a suitable pull distance
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()