from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Task: Uncover a drawer by opening it.
    Oracle Plan (per specification):
      1. execute_pick <handle_object> <handle_location>
      2. execute_pull <drawer> <handle_object> <handle_location>
    """

    robot = RobotController()

    # ========== Parameter Choices from Observation and Mapping ==========
    # Since all drawers are closed, all handles are on the floor (from observation),
    # we can choose any drawer/handle. Choose top for clarity.
    # drawer: drawer1 --> corresponds to drawer_top_handle
    # handle_object: handle1 --> corresponds to drawer_top_handle
    # handle_location: floor

    # According to Object_list:
    # - "drawer_top_handle": corresponds to "handle1" (for "drawer1": top drawer)
    #   position, pose, or any relevant info is in Object["drawer_top_handle"]
    # - handle is on the floor (from observation and mapping)
    # Thus, to pick the handle (approach along x-axis), use axis=0.

    try:
        # Step 1: Pick up the drawer top handle (handle1)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick: {e}")
        return

    try:
        # Step 2: Pull (open) the top drawer using the handle
        # execute_pull(d, h, p): d=drawer1, h=handle1, p=handle_location("floor")
        # Approach axis for pulling drawer handle: x-axis (0)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull: {e}")
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()