from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    # Step 1: execute_pick(handle3, ready-pose)
    # In Object_list, "drawer_bottom_handle" is mapped to handle3 (per object_names provided).
    # Approach handles along the x-axis (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Failed to pick handle3 (drawer_bottom_handle): {e}")

    # Step 2: execute_pull(drawer3, handle3, ready-pose)
    # "drawer3" corresponds to the bottom drawer. Pulling handles is always axis=0 (x-axis).
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Failed to pull open drawer3 with handle3 (drawer_bottom_handle): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()