from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Task: Open up one of the drawers (drawer3), according to the oracle plan and using only provided skills.
    The actions are:
    1. execute_pick(handle3 at ready-pose), approach along x-axis (axis=0)
    2. execute_pull(drawer3, handle3, at ready-pose), approach along x-axis (axis=0)
    """

    robot = RobotController()

    try:
        # Step 1: Pick the handle3 (drawer3's handle) at ready-pose, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: Pull (open) the drawer3 by pulling handle3, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Exception during drawer opening task: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()