from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: execute_pick("handle3", "ready-pose")
        # Corresponds to picking up the drawer handle to open it
        # We must select the correct handle corresponding to drawer3: "drawer_bottom_handle"
        # Mapping handle3 -> "drawer_bottom_handle", and axis=0 for handles
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 2: execute_pull("drawer3", "handle3", "ready-pose")
        # This pulls the bottom drawer open using the handle
        # For execute_pull: movement mode=4, axis is not required, but set axis=0 for drawer pulls
        # Use a slightly larger distance to ensure sufficient pull
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()