from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for the 'Open one drawer.' task.
    Uses only provided skills: execute_pick (mode=1), execute_pull (mode=4).
    Follows the required_steps specification:
        1. execute_pick(handle_bottom, ready-pose)
        2. execute_pull(drawer_bottom, handle_bottom, ready-pose)
    """
    robot = RobotController()
    # Step 1: Pick the drawer bottom handle (approach along x-axis: axis=0)
    try:
        # "drawer_bottom_handle" is mapped from handle_bottom
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error in execute_pick handle_bottom:", e)
        return

    # Step 2: Pull the drawer bottom (with handle_bottom) (approach along x-axis: axis=0)
    try:
        # Pull the drawer using the handle; pulling distance may be tuned (default 0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print("Error in execute_pull drawer_bottom:", e)
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()