from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    # === TASK PLAN: Pull open a single drawer using only the required skills ===
    # We'll use the bottom drawer as the example.

    try:
        # 1. Pick the bottom drawer handle (execute_pick)
        #    - Object: drawer_bottom_handle
        #    - Axis: approach along the x-axis (axis=0) as per task instruction for handles
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Failed to pick drawer handle: {e}")
        return

    try:
        # 2. Pull (open) the drawer while holding the handle (execute_pull)
        #    - Object: same position as handle
        #    - Mode: 4 (execute_pull)
        #    - Distance: set a reasonable pull distance (e.g., 0.1 meters)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Failed to pull (open) the drawer: {e}")
        return


def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()