from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick handle_bottom at ready-pose (as per specification)
    try:
        # Use Object key for 'handle_bottom'
        handle_bottom = Object.get("handle_bottom", None)
        ready_pose = Object.get("ready-pose", None)
        if handle_bottom is None:
            raise ValueError("handle_bottom not found in Object list.")
        if ready_pose is None:
            raise ValueError("ready-pose not found in Object list.")
        # For picking a handle, axis=0 (approach along x-axis)
        # The skeleton expects the 'pose0' argument to be the target object pose (handle), so we use handle_bottom.
        # If location is needed explicitly, pose1 can be used, but as per skill_code, only pose0 is required for pick.
        robot.execute_movement(handle_bottom, mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_bottom at ready-pose: {e}")

    # Step 2: Pull the bottom drawer using handle_bottom at ready-pose
    try:
        drawer_bottom = Object.get("drawer_bottom", None)
        # For 'execute_pull', the skill interface expects 'pose0' as the handle, and arguments for axis & distance.
        # To fully match the plan params, ensure all arguments ("drawer_bottom", "handle_bottom", "ready-pose") are obtained.
        if drawer_bottom is None:
            raise ValueError("drawer_bottom not found in Object list.")
        # The actual movement function uses 'handle_bottom' as pose0, mode=4 for pull action.
        # In this setting, we assume handle_bottom indicates the correct pose for pulling.
        # The ready-pose is used for initial location context; if needed for position adjustment, that would require a move action,
        # but per skeleton and skills, we pass the pose as handle_bottom, axis=0, and set a generous pull distance for reliability.
        robot.execute_movement(handle_bottom, mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom with handle_bottom at ready-pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()