from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick handle_bottom at ready-pose
        # "handle_bottom" maps to "drawer_bottom_handle"
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: execute_pull drawer_bottom via handle_bottom at ready-pose
        # "drawer_bottom" handle is "drawer_bottom_handle"
        # Use mode=4 (pull), provide distance as per drawer opening, object loc is drawer_bottom_handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()