from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === PDDL/Spec Analysis ===
    # Goal: Pull open a single drawer.
    # Spec requires: execute_pick + execute_pull sequence on a handle (any of the 3).
    #
    # We choose the bottom drawer handle for this task.
    # Mapping:
    #   handle_object: "handle_bottom" (from PDDL)
    #   Object list:   "drawer_bottom_handle"
    #   drawer:        "drawer_bottom"
    #   <handle_location>:   Object["drawer_bottom_handle"]
    #
    #   But in available Object[], the handles are named:
    #      "drawer_bottom_handle", ...
    #
    # So, mapping:
    #   PDDL handle_bottom        =>  drawer_bottom_handle (Object[])
    #   handle_location           =>  Object["drawer_bottom_handle"]
    #   drawer_bottom (not needed directly, as we're picking/pulling by handle)
    #
    # Task steps:
    #   1. Pick the handle (execute_pick)
    #      axis = 0 (approach along x for handles)
    #   2. Pull the handle (execute_pull)
    #      axis = 0 (approach along x), distance = e.g. 0.08 (reasonable for a drawer)
    #
    # Error handling included for robustness.

    # Step 1: execute_pick on the chosen handle
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[Error] Failed to execute_pick on 'drawer_bottom_handle': {e}")
        return

    # Step 2: execute_pull on the chosen handle
    try:
        # distance is left blank in spec, but typical drawer pull might be 0.08m
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.08)
    except Exception as e:
        print(f"[Error] Failed to execute_pull on 'drawer_bottom_handle': {e}")
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()