from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle_bottom, ready-pose)
        # 'handle_bottom' is mapped to "drawer_bottom_handle" in Object list
        # Approach drawer handles along the x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    try:
        # Step 2: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # After picking the handle, pull the "drawer_bottom" using its handle
        # Use mode=4 for execute_pull. Use a slightly longer distance for a full pull.
        # Per the convention, use the handle's pose for pulling
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
