"""Module to open one drawer using the robot controller."""
from object_list import OBJECTS
from skill_mapping import RobotController

def open_one_drawer():
    """Open any one closed and unlocked drawer."""
    robot = RobotController()
    # Find a closed and unlocked drawer and its handle
    for drawer_name in ["drawer_bottom", "drawer_middle", "drawer_top"]:
        drawer = OBJECTS.get(drawer_name)
        handle = OBJECTS.get(f"{drawer_name}_handle")
        if drawer is None or handle is None:
            continue
        if robot.is_drawer_closed(drawer) and robot.is_drawer_unlocked(drawer):
            # Move to handle location
            robot.move_to(handle.location)
            # Pick the handle
            robot.pick(handle)
            # Pull to open the drawer
            robot.pull_drawer(drawer, handle)
            return
    print("No closed and unlocked drawer found to open.")

def main():
    """Main entry point to open one drawer."""
    open_one_drawer()

if __name__ == "__main__":
    main()