"""Module to uncover a drawer by opening it."""

from object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Uncover a drawer by opening it."""
    robot = RobotController()

    # Step 1: Pick up the handle of a drawer (e.g., handle_bottom at ready-pose)
    # Mapping: handle_bottom -> Object["drawer_bottom_handle"]
    # Approach axis: 0 (x-axis) for handles
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

    # Step 2: Pull to open the drawer using the handle
    # Mapping: drawer_bottom, handle_bottom, ready-pose
    # Use the handle's pose for pulling as well
    # Use a slightly larger distance for drawer pull
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

def main():
    """Main entry point to uncover a drawer by opening it."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()