"""Module to pull open a single drawer using a robot controller."""

from object_list import OBJECTS
from skill_mapping import RobotController

def pull_open_single_drawer():
    """Pull open a single drawer."""
    robot = RobotController()
    # Select any available drawer and its handle
    # For generality, pick the first drawer and its handle from OBJECTS
    for drawer_name, drawer_data in OBJECTS.items():
        if drawer_data.get("type") == "drawer":
            handle_name = drawer_data.get("handle")
            if handle_name and handle_name in OBJECTS:
                handle_obj = OBJECTS[handle_name]
                # Move to the handle
                robot.execute_movement(handle_obj, mode=1, axis=0)
                # Pull to open the drawer
                robot.execute_movement(handle_obj, mode=4)
                break

def main():
    """Main entry point to pull open a single drawer."""
    pull_open_single_drawer()

if __name__ == "__main__":
    main()