"""Module to open any one of the drawers using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def open_any_drawer():
    """Open any one of the drawers."""
    robot = RobotController()
    # List of available handles corresponding to drawers
    handles = [
        "drawer_bottom_handle",
        "drawer_middle_handle",
        "drawer_top_handle"
    ]
    for handle_name in handles:
        try:
            # Attempt to pick up the handle at ready-pose (axis=0 for handle grasping)
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Attempt to pull to open the drawer using the handle (mode=4 is execute_pull, distance=0.1 for a full pull)
            robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
            # If both actions succeed, drawer is open; exit after opening one drawer
            return
        except Exception as error:
            # If failed, try the next handle
            continue

def main():
    """Main entry point to open any one of the drawers."""
    open_any_drawer()

if __name__ == "__main__":
    main()