from Object_list import Object
from skill_mapping import RobotController

def open_drawer():
    """
    Opens any available drawer by pulling its handle.
    """
    robot = RobotController()

    # Select any available drawer and its handle
    # For generality, pick the first available handle and its associated drawer
    for handle_name, handle_pose in Object.items():
        if "handle" in handle_name:
            # Derive drawer name from handle name
            drawer_name = handle_name.replace("handle", "drawer")
            # Attempt to pick the handle
            try:
                robot.execute_movement(handle_pose, mode=1, axis=0)
            except Exception as error:
                print(f"Error during execute_pick: {error}")
                continue
            # Attempt to pull the drawer open
            try:
                robot.execute_movement(handle_pose, mode=4, distance=0.1)
            except Exception as error:
                print(f"Error during execute_pull: {error}")
                continue
            # Drawer opened, task complete
            return

def main():
    """
    Main function to open a drawer.
    """
    open_drawer()

if __name__ == "__main__":
    main()