"""Module to open one drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """Open any available drawer."""
    robot = RobotController()

    # List of candidate drawers and their handles
    drawers = [
        ("drawer_bottom", "handle_bottom"),
        ("drawer_middle", "handle_middle"),
        ("drawer_top", "handle_top"),
    ]

    for drawer_name, handle_name in drawers:
        drawer = Object.get(drawer_name)
        handle = Object.get(f"{drawer_name}_handle") if f"{drawer_name}_handle" in Object else Object.get(handle_name)
        if drawer is None or handle is None:
            continue

        # Check if the drawer is unlocked and closed
        if getattr(drawer, "is_unlocked", False) and getattr(drawer, "is_closed", False):
            try:
                robot.execute_movement(handle, mode=1, axis=0)
            except Exception as error:
                print(f"Error in execute_pick for {handle_name}: {error}")
                continue

            try:
                robot.execute_movement(handle, mode=4, distance=0.1, axis=0)
            except Exception as error:
                print(f"Error in execute_pull for {handle_name}: {error}")
                continue

            # Drawer opened, exit after opening one
            break

def main():
    """Main entry point to open one drawer."""
    open_one_drawer()

if __name__ == "__main__":
    main()