from Object_list import Object
from skill_mapping import RobotController

def pull_open_drawer(drawer_name, handle_name, location_name):
    """
    Pull open a single drawer by picking up its handle and pulling.
    Args:
        drawer_name (str): Name of the drawer to open.
        handle_name (str): Name of the handle attached to the drawer.
        location_name (str): Name of the location where the robot starts.
    """
    robot = RobotController()
    try:
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        robot.execute_movement(Object[handle_name], mode=4, distance=0.1, axis=0)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    # Example: open the bottom drawer
    pull_open_drawer("drawer_bottom", "handle_bottom", "ready-pose")

if __name__ == "__main__":
    main()