"""Module to open one of the drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open one of the drawers (bottom drawer) by grasping its handle and pulling."""
    robot = RobotController()
    try:
        # Pick the handle of the bottom drawer at ready-pose (axis=0 for handle grasp)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Pull the bottom drawer using its handle at ready-pose (mode=4 is pull, axis=0 by default)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()