"""Module to uncover a drawer by opening it."""
from Object_list import Object
from skill_mapping import RobotController

def uncover_drawer_by_opening():
    """Uncover a drawer by opening it."""
    robot = RobotController()
    try:
        # Pick a handle of a closed, unlocked drawer (choose bottom drawer for demonstration)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Pull the drawer open using the handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to uncover a drawer by opening it."""
    uncover_drawer_by_opening()

if __name__ == "__main__":
    main()