"""Module to slide one drawer open."""
from Object_list import Object
from skill_mapping import RobotController

def slide_one_drawer_open():
    """Slide any one available drawer open."""
    robot = RobotController()
    # List of candidate drawers and their handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    for drawer, handle in drawers:
        try:
            # Try to pick the handle
            robot.execute_movement(Object[handle], mode=1, axis=0)
            # Try to pull the drawer open
            robot.execute_movement(Object[handle], mode=4, axis=0, distance=0.1)
            return
        except Exception as error:
            print(f"Failed to open {drawer}: {error}")
    print("Could not open any drawer.")

def main():
    """Main entry point to slide one drawer open."""
    slide_one_drawer_open()

if __name__ == "__main__":
    main()