"""Module to open (uncover) any available drawer."""
from Object_list import Object
from skill_mapping import RobotController

def open_drawer(drawer_name):
    """Open (uncover) the specified drawer if possible."""
    robot = RobotController()
    handle_name = f"{drawer_name}_handle"
    try:
        # Approach the handle of the specified drawer
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        # Pull to open the drawer using the handle
        robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Failed to open {drawer_name}: {error}")

def main():
    # Try to open any available drawer (bottom, middle, top)
    for drawer in ["drawer_bottom", "drawer_middle", "drawer_top"]:
        open_drawer(drawer)

if __name__ == "__main__":
    main()