from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle of the bottom drawer from ready-pose
        #   Spec: execute_pick(handle_bottom, ready-pose)
        #   Mapping: Object name = "drawer_bottom_handle"
        #   Axis: For handles use axis=0 (along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error during execute_pick on drawer_bottom_handle:", e)

    try:
        # Step 2: Pull open the bottom drawer using the handle
        #   Spec: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        #   Here, Object["drawer_bottom_handle"] is used as the handle object pose
        #   Axis: For pulling handles use axis=0 (x-axis)
        #   Set a suitable pulling distance (e.g., distance=0.1 as in the skill skeleton)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print("Error during execute_pull on drawer_bottom_handle:", e)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()