from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    # Step 1: Pick handle1 (drawer_top_handle) at ready-pose. Approach along x-axis (axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_top_handle: {e}")

    # Step 2: Pull drawer1 using handle1 at ready-pose. Approach along x-axis (axis=0); use distance=0.1 for pull
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer1/handle1: {e}")

    # Step 3: Pick handle2 (drawer_middle_handle) at ready-pose. Approach along x-axis (axis=0)
    try:
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_middle_handle: {e}")

    # Step 4: Pull drawer2 using handle2 at ready-pose. Approach along x-axis (axis=0); use distance=0.1 for pull
    try:
        robot.execute_movement(Object["drawer_middle_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer2/handle2: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
