from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to drawer3 (which we'll map to Object["drawer_bottom_handle"])
        # Assume "drawer3" is the bottom drawer (middle drawer is drawer2)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as e:
        print(f"Error in Step 1 (execute_go to drawer3): {str(e)}")

    try:
        # Step 2: Pick the handle of drawer3 ("handle3" corresponds to Object["drawer_bottom_handle"])
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 2 (execute_pick handle3): {str(e)}")

    try:
        # Step 3: Pull open drawer3 using handle3 (approach along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 3 (execute_pull drawer3): {str(e)}")

    try:
        # Step 4: Move from drawer3 to drawer2
        robot.execute_movement(Object["drawer_middle_handle"], mode=7)
    except Exception as e:
        print(f"Error in Step 4 (execute_go to drawer2): {str(e)}")

    try:
        # Step 5: Pick the handle of drawer2
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 5 (execute_pick handle2): {str(e)}")

    # Step 6: Do NOT pull open drawer2 because it is locked, as per the plan/specification

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()