from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick handle3 at ready-pose
        # According to object mapping: drawer3 handle is "drawer_bottom_handle"
        # However, in the provided object list, we have:
        # "drawer_top_handle": handle1
        # "drawer_middle_handle": handle2
        # "drawer_bottom_handle": handle3
        # So, handle3 = Object["drawer_bottom_handle"]
        # The pose/location is "ready-pose" (should be initial/default pose, thus use axis accordingly)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 2: execute_pull drawer3 with handle3 at ready-pose
        # Pull operation to open the unlocked, closed drawer3 using its handle
        # For execute_pull, mode=4, and pulling distance typical is 0.1 (can be set).
        # Again, pose is ready-pose.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during oracle plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
