from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """Executes the oracle plan to open two drawers by performing:
    1. Move to drawer-area from ready-pose
    2. Pick handle3 (for drawer3)
    3. Pull (open) drawer3 using handle3
    4. Pick handle1 (for drawer1)
    5. Pull (open) drawer1 using handle1
    """
    robot = RobotController()

    try:
        # Step 1: Go to drawer-area from ready-pose (can be movement to working area)
        # Since explicit movement implementation is not provided, but the "execute_go" skill is, we use it.
        # Assuming robot is initially at ready-pose. No object needed for movement.
        robot.execute_movement(mode=7)  # execute_go: robot moves to drawer-area (contextually)

        # Step 2: Pick handle3 (attached to drawer3). Approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull (open) drawer3 using handle3, from drawer-area. Pull requires axis=0.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: Pick handle1 (attached to drawer1). Approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 5: Pull (open) drawer1 using handle1, from drawer-area. Pull requires axis=0.
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"[ERROR] Exception during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()