from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to slide open two drawers (bottom and top) by picking their handles and pulling.
    """

    robot = RobotController()

    try:
        # Step 1: Pick handle_bottom at ready-pose (axis=0 for handle grasp)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: Pull to open drawer_bottom with handle_bottom at ready-pose (pull = mode 4)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # Step 3: Pick handle_top at ready-pose (axis=0 for handle grasp)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 4: Pull to open drawer_top with handle_top at ready-pose (pull = mode 4)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

    except KeyError as e:
        print(f"Object name not found in Object list: {e}")
    except Exception as ex:
        print(f"An unexpected error occurred during oracle execution: {ex}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()