from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: Move from 'ready-pose' to 'drawer-area'
        # In this environment, movement is handled by mode=7 (execute_go)
        # Since Object placements are not physically defined, we skip actual pose targets but can call movement.
        robot.execute_movement(mode=7)  # execute_go

        # Step 2: Pick handle_top (drawer_top_handle) at drawer-area
        # Approach along axis=0 (x-axis): appropriate for handle/drawer
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull open drawer_top (pull using handle_top at drawer-area)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 4: Pick handle_bottom (drawer_bottom_handle) at drawer-area
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # execute_pick

        # Step 5: Pull open drawer_bottom (pull using handle_bottom at drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()