from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Oracle Plan to Pull Open a Pair of Drawers ===
    try:
        # Step 1: Pick handle of bottom drawer ("handle_bottom" → "drawer_bottom_handle")
        # Use approach axis=0 (x-axis) for handle picking
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_bottom: {e}")

    try:
        # Step 2: Pull open bottom drawer via handle ("drawer_bottom", "handle_bottom" → "drawer_bottom_handle")
        # Use axis=0, and pull with a safe distance (e.g., 0.1m)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom: {e}")

    try:
        # Step 3: Pick handle of top drawer ("handle_top" → "drawer_top_handle")
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_top: {e}")

    try:
        # Step 4: Pull open top drawer via handle ("drawer_top", "handle_top" → "drawer_top_handle")
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_top: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
