from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Task: Open all unlocked drawers.
    According to observation, only drawer_top is unlocked and closed.
    Available skills: execute_pick, execute_go, execute_pull (these are required by the specification).
    Plan steps (per specification):
      1. execute_go from ready-pose to 'location_of_handle_top' (resolve as drawer_top_handle)
      2. execute_pick 'handle_top' at 'location_of_handle_top' (resolve as drawer_top_handle)
      3. execute_pull 'drawer_top' with 'handle_top' at 'location_of_handle_top' (resolve as drawer_top_handle)
    """
    robot = RobotController()

    # Step 1: "execute_go" from ready-pose to location_of_handle_top
    try:
        robot.execute_movement(
            pose0=Object["ready-pose"], 
            pose1=Object["drawer_top_handle"], 
            mode=7 # execute_go
        )
    except Exception as e:
        print("[ERROR] Failed to move to drawer_top_handle location:", e)

    # Step 2: "execute_pick" handle_top at location_of_handle_top
    # According to the domain: pick handle_top (which is on the floor at the location pose)
    try:
        robot.execute_movement(
            pose0=Object["drawer_top_handle"], 
            mode=1, # execute_pick
            axis=0  # approach along x-axis for handle
        )
    except Exception as e:
        print("[ERROR] Failed to pick drawer_top_handle:", e)

    # Step 3: "execute_pull" drawer_top using handle_top at location_of_handle_top
    # Pull should open the drawer
    try:
        robot.execute_movement(
            pose0=Object["drawer_top_handle"],
            mode=4,  # execute_pull
            axis=0, # approach along x-axis for handle
            distance=0.1 # typical value for drawer
        )
    except Exception as e:
        print("[ERROR] Failed to pull (open) drawer_top via handle:", e)

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()