from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Plan according to the specification steps:
    # Step 1: execute_pick("handle_bottom", "ready-pose")
    try:
        # "drawer_bottom_handle" corresponds to "handle_bottom" in the environment.
        # The robot is at "ready-pose", and the handle is at its location.
        # Approach axis for handles: 0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick on 'drawer_bottom_handle': {e}")

    # Step 2: execute_pull("drawer_bottom", "handle_bottom", "ready-pose")
    try:
        # Drawer-bottom's handle location is the same pose as "drawer_bottom_handle"
        # Axis: 0 (x-axis), Pulling out, set distance for full open
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for 'drawer_bottom' using 'drawer_bottom_handle': {e}")

    # Step 3: execute_pick("handle_top", "ready-pose")
    try:
        # "drawer_top_handle" corresponds to "handle_top"
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick on 'drawer_top_handle': {e}")

    # Step 4: execute_pull("drawer_top", "handle_top", "ready-pose")
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for 'drawer_top' using 'drawer_top_handle': {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()