from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # === Step 1: Pick handle_bottom at ready-pose ===
        # Map: handle_bottom -> Object["drawer_bottom_handle"]
        # Approach drawer handle along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # === Step 2: Pull (open) drawer_bottom using handle_bottom at ready-pose ===
        # Pull also along x-axis, increase distance for pull action
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # === Step 3: Pick handle_top at ready-pose (drawer_top handle) ===
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # === Step 4: Pull (open) drawer_top using handle_top at ready-pose ===
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()